ORCA/M Asm65816 2.1.0

0001 3505                       title 'QD Lines             GS ROM 2.0' 
0002 3505              ****************************************************************
0003 3505              *                                                              *
0004 3505              *              LINES                                           *
0005 3505              *                                                              *
0006 3505              ****************************************************************
0007 3505
0008 3505
0009 3505              ****************************************************************
0010 3505              *                                                              *
0011 3505              *                  Copyright (C) 1985-1987                     *
0012 3505              *                  All Rights Reserved                         *
0013 3505              *                  Apple Computer, Inc.                        *
0014 3505              *                                                              *
0015 3505              ****************************************************************
0016 3505
0017 3505                       string asis 
0018 3505                       blanks off 
0019 3505
0020 3505
0021 3505                       include 'all.macros' 
0022 3505                       include ':QDEquates:qd.data.asm' 
0023 3505
0024 3505
0025 3505                       INCLUDE ':QDEquates:CORE.GLOBALS1' 
0026 3505                       INCLUDE ':QDEquates:core.globals2' 
0027 3505                       INCLUDE ':QDEquates:region.equs' 
0028 3505                       INCLUDE ':QDEquates:RECT.EQUS' 
0029 3505                       INCLUDE ':QDEquates:SLAB.EQUS' 
0030 3505                       INCLUDE ':QDEquates:LINE.EQUS' 
0031 3505
0032 3505
0033 3505              ;-----------------------------------------------
0034 3505              ;
0035 3505              ;   Imported addresses
0036 3505              ;
0037 3505              ;-----------------------------------------------
0038 3505
0039 3505                       IMPORT BusyErr4 
0040 3505                       IMPORT CheckPenVis 
0041 3505                       IMPORT GrabPenSize 
0042 3505                       IMPORT MinRectToY1 
0043 3505                       IMPORT NextPatSlice 
0044 3505                       IMPORT QDStart 
0045 3505                       IMPORT RgnSave 
0046 3505                       IMPORT SetFirstDestRef 
0047 3505                       IMPORT SetNextDestRef 
0048 3505                       IMPORT TestGPs 
0049 3505
0050 3505              ;-----------------------------------------------
0051 3505              ;
0052 3505              ;   Forward addresses and entries
0053 3505              ;
0054 3505              ;-----------------------------------------------
0055 3505
0056 3505                       ENTRY CallLine 
0057 3505                       ENTRY GrabPenLoc 
0058 3505                       ENTRY StabPenLoc 
0059 3505
0060 3505
0061 3505              ;                COPY LINES/LINES
0062 3505              ****************************************************************
0063 3505              *
0064 3505              * LineTo   (h,v : integer);
0065 3505              *
0066 3505              ****************************************************************
0067 3505                       EXPORT LineTo 
0068 3505              LineTo   PROC 
0069 3505
0070 3505              OrigDirect equ   1
0071 3505              RTL1     equ   OrigDirect+2
0072 3505              RTL2     equ   RTL1+3
0073 3505              V        equ   RTL2+3
0074 3505              H        equ   V+2
0075 3505
0076 3505 20 AA 0F              jsr   QDStart
0077 3508
0078 3508 20 C7 38              jsr   GrabPenLoc
0079 350B
0080 350B A3 09                 lda   V,s                      ; put ending point in
0081 350D 85 AA                 sta   Y2                       ; Y2,X2 and Rect2+4
0082 350F 85 B2                 sta   Rect2+4
0083 3511
0084 3511 A3 0B                 lda   H,s
0085 3513 85 AC                 sta   X2
0086 3515 85 B4                 sta   Rect2+6
0087 3517
0088 3517
0089 3517                       EXPORT ShareLine 
0090 3517              ShareLine                               ; 
0091 3517
0092 3517 20 D9 38              jsr   StabPenLoc
0093 351A
0094 351A 22 3C 35 FE           jsl   CallLine
0095 351E
0096 351E AA                    tax   
0097 351F 4C 1C FC              jmp   BusyErr4
0098 3522
0099 3522
0100 3522
0101 3522                       ENDP 
0102 3522
0103 3522
0104 3522
0105 3522              ****************************************************************
0106 3522              *
0107 3522              * Line  (dh,dv : integer);
0108 3522              *
0109 3522              ****************************************************************
0110 3522                       EXPORT Line 
0111 3522              Line     PROC 
0112 3522              OrigDirect equ   1
0113 3522              RTL1     equ   OrigDirect+2
0114 3522              RTL2     equ   RTL1+3
0115 3522              dv       equ   RTL2+3
0116 3522              dh       equ   dv+2
0117 3522
0118 3522 20 AA 0F              jsr   QDStart
0119 3525
0120 3525 20 C7 38              jsr   GrabPenLoc
0121 3528
0122 3528 A5 A6                 lda   Y1
0123 352A 18                    clc                            ; then calculate end point
0124 352B 63 09                 adc   dv,s                     ; and point it
0125 352D 85 AA                 sta   Y2                       ; in Y2
0126 352F 85 B2                 sta   Rect2+4                  ; and Rect2+4
0127 3531
0128 3531
0129 3531 A5 A8                 lda   X1                       ; Do again for X
0130 3533 18                    clc   
0131 3534 63 0B                 adc   dh,s
0132 3536 85 AC                 sta   X2
0133 3538 85 B4                 sta   Rect2+6
0134 353A
0135 353A 80 DB                 bra   ShareLine
0136 353C
0137 353C                       ENDP 
0138 353C
0139 353C
0140 353C
0141 353C              ****************************************************************
0142 353C              *
0143 353C              * CallLine
0144 353C              *
0145 353C              * Internal routine which calls standard line or the
0146 353C              * appropriate routine attached to the graf port.
0147 353C              ****************************************************************
0148 353C                       EXPORT CallLine 
0149 353C              CallLine PROC 
0150 353C                       Import DrawLine2 
0151 353C              *              using QDProcs
0152 353C              *              using E0Vectors
0153 353C A2 00 02              ldx   #512                     ; test the DirtyDPFlags for picts and pen...
0154 353F B5 EC                 lda   <DirtyDPFlags,x
0155 3541 29 3F A4              and   #TestLineDrawState
0156 3544 C9 3F A4              cmp   #TestLineDrawState
0157 3547 F0 16                 beq   DoFasterSetup            ; if this is zero, then pen vis/no pictures etc...
0158 3549
0159 3549 20 C3 0F              jsr   TestGPs
0160 354C B0 04                 bcs   NotStandard
0161 354E
0162 354E 5C 08 1E E0           jml   StdLine
0163 3552
0164 3552
0165 3552 8B           NotStandard phb                         ; put a byte on the stack
0166 3553 A0 04 00              ldy   #o_stdline               ; get pointer to new stdline
0167 3556 B7 2A                 lda   [temp],y                 ; in a-reg
0168 3558 48                    pha                            ; push it
0169 3559 C8                    iny                            ; get middle and high byte
0170 355A B7 2A                 lda   [temp],y                 ; of pointer
0171 355C 83 02                 sta   2,s                      ; over store middle byte 2 times
0172 355E 6B                    rtl                            ; go there
0173 355F
0174 355F              DoFasterSetup  
0175 355F 20 2F 34              jsr   GrabPenSize              ; don't come back if part is zero
0176 3562 8B                    phb                            ; save the bank register
0177 3563 A0 48 00              ldy   #O_PnMode                ; get the mode down to zp
0178 3566 B7 24                 lda   [PortRef],y
0179 3568 85 B6                 sta   FillMode
0180 356A
0181 356A 4C 95 35              jmp   DrawLine2
0182 356D
0183 356D
0184 356D                       ENDP 
0185 356D
0186 356D
0187 356D              ****************************************************************
0188 356D              *
0189 356D              * StdLine
0190 356D              *
0191 356D              *
0192 356D              ****************************************************************
0193 356D                       EXPORT iStdLine 
0194 356D              iStdLine PROC 
0195 356D              *              using CoreDATA
0196 356D              *              using PicInfo
0197 356D              *              using E0Vectors
0198 356D
0199 356D A9 20 00              lda   #LineNoun
0200 3570 22 F8 1E E0           jsl   PutPictStuff
0201 3574 90 01                 bcc   NoPicErr
0202 3576 6B                    rtl   
0203 3577
0204 3577 22 FC 1E E0  NoPicErr jsl   AddToPoly                ; are we saving a poly
0205 357B 90 01                 bcc   NoPolyErr
0206 357D 6B                    rtl   
0207 357E
0208 357E 20 45 6B     NoPolyErr jsr   RgnSave
0209 3581 90 07                 bcc   NoRgnErr
0210 3583
0211 3583 22 80 1F E0           jsl   PutLine
0212 3587 90 01                 bcc   NoRgnErr
0213 3589 6B                    rtl                            ; return the error
0214 358A
0215 358A              NoRgnErr                                ; 
0216 358A              ****************************************************************
0217 358A              *
0218 358A              * DrawLine
0219 358A              *
0220 358A              * The common line drawing routine.  Draws a line from Point1
0221 358A              * to Point2.
0222 358A              *
0223 358A              * By the time control gets here, the Starting and Ending
0224 358A              * points are in Y1,X1 and Y2,X2 as well as Rect2.  The Slab
0225 358A              * routines and XSetup use X1 and X2 for the starting and
0226 358A              * stopping points of a horizontal line segment.
0227 358A              *
0228 358A              * We start by building the rectangle that bounds the line and
0229 358A              * clipping it.  if the clip results in no rect, we are done.
0230 358A              * After the clip, we calculate the slope and initial left and
0231 358A              * right edges, using the unclipped points. (Using the clipped
0232 358A              * points would not give the right results.)  Finally, we adjust
0233 358A              * the left and right edge if the top was clipped by the clipping
0234 358A              * amound * slope.  The Line is drawn by using the vertical limits
0235 358A              * obtained from the clipped rectangle.
0236 358A              *
0237 358A              * Uses Three new variables on Zero Page:
0238 358A              *     Slope      a fixed point value, the slope of the line
0239 358A              *     LeftEdge   a fixed point value, for the current starting x.
0240 358A              *     RightEdge  a fixed point value, for the currend stopping x.
0241 358A              *
0242 358A              *
0243 358A              * Modification History:
0244 358A              *
0245 358A              *   18 Mar 86      Checked all compares and used signed instead of unsigned
0246 358A              *                  branches.
0247 358A              *
0248 358A              * 2/27/89          Mensch
0249 358A              * Try dropping a newer fastratio routine in...
0250 358A              *
0251 358A              * 3/9/89           Mensch
0252 358A              * Added short circut to check pen vis and portloc to ZP
0253 358A              ****************************************************************
0254 358A                       EXPORT DrawLine 
0255 358A                       Export DrawLine2 
0256 358A                       Import FastRatio 
0257 358A              DrawLine                                ; 
0258 358A 20 17 34              jsr   CheckPenVis              ; don't come back unless visible
0259 358D 20 2F 34              jsr   GrabPenSize              ; don't come back if part is zero
0260 3590
0261 3590 8B                    phb                            ; save the bank register
0262 3591
0263 3591 22 6C 1E E0           jsl   PreDraw
0264 3595              DrawLine2  
0265 3595 22 A0 1E E0           jsl   SetUpPortRegions
0266 3599
0267 3599
0268 3599              ;-------------------------------------------
0269 3599              ;
0270 3599              ;  Make Line Rect in y1,x1 y2,x2
0271 3599              ;
0272 3599
0273 3599 A5 AA                 lda   Y2                       ; want to draw top to
0274 359B C5 A6                 cmp   Y1                       ; bottom so if Y2 >= Y1
0275 359D 10 06                 bpl   NoYSwap                  ; then okay
0276 359F
0277 359F A4 A6                 ldy   Y1
0278 35A1 84 AA                 sty   Y2
0279 35A3 85 A6                 sta   Y1
0280 35A5
0281 35A5 A5 AC        NoYSwap  lda   X2
0282 35A7 C5 A8                 cmp   X1
0283 35A9 10 06                 bpl   NoXSwap
0284 35AB
0285 35AB A4 A8                 ldy   X1
0286 35AD 85 A8                 sta   X1
0287 35AF 84 AC                 sty   X2
0288 35B1
0289 35B1              NoXSwap                                 ; 
0290 35B1
0291 35B1              ;------------------------------------------------
0292 35B1              ;
0293 35B1              ;  Now adjust the Line rect by the pen width
0294 35B1              ;  and height
0295 35B1              ;
0296 35B1 A5 AA                 lda   Y2
0297 35B3 18                    clc   
0298 35B4 65 B8                 adc   LocalPnSize
0299 35B6 85 AA                 sta   Y2
0300 35B8
0301 35B8 A5 AC                 lda   X2                       ; adjust X2 by pen size too
0302 35BA 18                    clc   
0303 35BB 65 BA                 adc   LocalPnSize+2
0304 35BD 85 AC                 sta   X2
0305 35BF
0306 35BF              ;------------------------------------------------
0307 35BF              ;
0308 35BF              ;  Need to clip Rect2 to intersection of Bounds
0309 35BF              ;  and port rects.
0310 35BF              ;
0311 35BF 22 90 1E E0           jsl   BMakeMinRect             ; clip it
0312 35C3 90 03                 bcc   Continue                 ; if clear then intersection not
0313 35C5 4C 8A 37              jmp   NeverMind                ; empty else done.
0314 35C8
0315 35C8
0316 35C8              ;------------------------------------------------
0317 35C8              ;
0318 35C8              ;   Test for Horizontal or Vertical Lines
0319 35C8              ;
0320 35C8
0321 35C8              Continue                                ; 
0322 35C8
0323 35C8 22 98 1E E0           jsl   ShieldCursor
0324 35CC 20 88 4D              jsr   MinRectToY1
0325 35CF
0326 35CF A5 B4                 lda   Rect2+6
0327 35D1 C5 B0                 cmp   Rect2+2
0328 35D3 F0 18                 beq   AnHVLine
0329 35D5
0330 35D5 A5 AE                 lda   Rect2
0331 35D7 C5 B2                 cmp   Rect2+4
0332 35D9 30 19                 bmi   PointsInOrder
0333 35DB F0 10                 beq   AnHVLine
0334 35DD
0335 35DD A4 B2                 ldy   Rect2+4                  ; Top greater than bottom so
0336 35DF 84 AE                 sty   Rect2                    ; swap them
0337 35E1 85 B2                 sta   Rect2+4
0338 35E3
0339 35E3 A5 B0                 lda   Rect2+2                  ; swap x's to match
0340 35E5 A4 B4                 ldy   Rect2+6
0341 35E7 84 B0                 sty   Rect2+2
0342 35E9 85 B4                 sta   Rect2+6
0343 35EB 80 07                 bra   PointsInOrder
0344 35ED
0345 35ED 22 78 1E E0  AnHVLine jsl   DrawRect                 ; now get out of here for good
0346 35F1 4C 86 37              jmp   TheEnd
0347 35F4              ;----------------------------------------
0348 35F4              ;
0349 35F4              ;  Initialize the left and right edges
0350 35F4              ;
0351 35F4
0352 35F4 A9 00 80     PointsInOrder lda   #$8000              ; make fractional parts 1/2
0353 35F7 85 D6                 sta   LeftEdge                 ; Gives us free rounding
0354 35F9 85 DA                 sta   RightEdge
0355 35FB A5 B0                 lda   Rect2+2                  ; set up left and right edge
0356 35FD 85 D8                 sta   LeftEdge+2               ; RightEdge = LeftEdge+PenWidth
0357 35FF 18                    clc   
0358 3600 65 BA                 adc   LocalPnSize+2
0359 3602 85 DC                 sta   RightEdge+2
0360 3604
0361 3604
0362 3604              ;------------------------------------------------
0363 3604              ;
0364 3604              ;   Caculate the inverted slope (dh/dv) using
0365 3604              ;   original points
0366 3604              ;
0367 3604
0368 3604 48                    pha                            ; put room for result on stack
0369 3605 48                    pha   
0370 3606
0371 3606 A5 B4                 lda   Rect2+6
0372 3608 38                    sec   
0373 3609 E5 B0                 sbc   Rect2+2
0374 360B 48                    pha                            ; put delta x on stack
0375 360C A5 B2                 lda   Rect2+4
0376 360E 38                    sec   
0377 360F E5 AE                 sbc   Rect2
0378 3611 48                    pha                            ; put Delta y on stack
0379 3612
0380 3612 20 E7 38              jsr   FastRatio
0381 3615              ;	_FixRatio		; get the ratio
0382 3615
0383 3615 68                    pla                            ; pull of the ratio
0384 3616 85 D2                 sta   Slope
0385 3618 68                    pla   
0386 3619 85 D4                 sta   Slope+2
0387 361B
0388 361B
0389 361B              ;----------------------------------------------
0390 361B              ;
0391 361B              ;    Now need to adjust the distance between
0392 361B              ;    left and right edges.
0393 361B              ;
0394 361B
0395 361B              ;----------------------------------------------
0396 361B              ;
0397 361B              ;   Calculate the adjust = Pen Height * Slope
0398 361B              ;
0399 361B              ; 3/9/89           Mensch
0400 361B              ; Modified to see if LocalPnSize is 1 or 2, if so, we do a simple multiply
0401 361B              ; else we do a standard fix multiply
0402 361B              ; Also, preset adjust to be the slope...
0403 361B
0404 361B A5 D4                 lda   Slope+2
0405 361D 85 E4                 sta   Adjust+2
0406 361F A5 D2                 lda   Slope
0407 3621 85 E2                 sta   Adjust
0408 3623
0409 3623 A5 B8                 lda   LocalPnSize
0410 3625 C9 01 00              cmp   #1                       ; if its 1, the noMult
0411 3628 F0 25                 beq   @Mult1Done
0412 362A C9 02 00              cmp   #2                       ; if its 2 do a simple multiply
0413 362D F0 1C                 beq   @Multby2
0414 362F              ; else, just do it the long way...
0415 362F 48                    pha                            ; Make Room for result
0416 3630 48                    pha   
0417 3631
0418 3631 48                    pha   
0419 3632 A9 00 00              lda   #0
0420 3635 48                    pha   
0421 3636 A5 D4                 lda   Slope+2
0422 3638 48                    pha   
0423 3639 A5 D2                 lda   Slope
0424 363B 48                    pha   
0425 363C
0426 363C A2 0B 0F 22           _FixMul 
0427 3643
0428 3643 68                    pla   
0429 3644 85 E2                 sta   Adjust
0430 3646 68                    pla   
0431 3647 85 E4                 sta   Adjust+2
0432 3649 80 04                 bra   @Mult1Done
0433 364B              @MultBy2  
0434 364B 06 E2                 asl   Adjust
0435 364D 26 E4                 rol   Adjust+2
0436 364F              @Mult1Done  
0437 364F              ;-------------------------------------------------------
0438 364F              ;
0439 364F              ;   Adjust the Left and Right edges depending on sign
0440 364F              ;   magnitude of slope
0441 364F              ;
0442 364F              ; WAS:
0443 364F              ;	lda	Slope+2
0444 364F              ;	asl	a	; get sign bit into carry
0445 364F              ;	lda	Slope+2	; get back orig
0446 364F              ;	ror	a	; divide by 2 preserving sign
0447 364F              ;	sta	SlopeTemp+2
0448 364F              ;	lda	Slope
0449 364F              ;	ror	a
0450 364F              ;	sta	SlopeTemp
0451 364F              ;	ldx	#4
0452 364F              ;AdjustLoop	lda	LeftEdge,x
0453 364F              ;	clc
0454 364F              ;	adc	SlopeTemp
0455 364F              ;	sta	LeftEdge,x
0456 364F              ;	lda	LeftEdge+2,x
0457 364F              ;	adc	SlopeTemp+2
0458 364F              ;	sta	LeftEdge+2,x
0459 364F              ;	dex
0460 364F              ;	dex
0461 364F              ;	dex
0462 364F              ;	dex
0463 364F              ;	bpl	AdjustLoop
0464 364F              ;
0465 364F              ; IS NOW
0466 364F A5 D4                 lda   Slope+2
0467 3651 0A                    asl   a                        ; get sign into carry
0468 3652 A5 D4                 lda   Slope+2                  ; get back orig
0469 3654 6A                    ror   a                        ; rotate putting sign back
0470 3655 A8                    tay                            ; save this in <Y> for a sec...
0471 3656 A5 D2                 lda   Slope
0472 3658 6A                    ror   a
0473 3659 AA                    tax   
0474 365A              ; Now adjust it...
0475 365A 18                    clc   
0476 365B 65 D6                 adc   LeftEdge
0477 365D 85 D6                 sta   LeftEdge
0478 365F 98                    tya                            ; get slopetemp+2 back
0479 3660 65 D8                 adc   leftEdge+2
0480 3662 85 D8                 sta   leftEdge+2
0481 3664
0482 3664 18                    clc                            ; and do it again...
0483 3665 8A                    txa                            ; get SlopeTemp Back
0484 3666 65 DA                 adc   LeftEdge+4
0485 3668 85 DA                 sta   LeftEdge+4
0486 366A 98                    tya   
0487 366B 65 DC                 adc   LeftEdge+6
0488 366D 85 DC                 sta   LeftEdge+6
0489 366F              ; shorter and sweeter
0490 366F
0491 366F 24 D4                 bit   Slope+2                  ; is the slope negative
0492 3671 30 24                 bmi   IsNegative
0493 3673
0494 3673              ;----------------------------------------------
0495 3673              ;
0496 3673              ;    Slope Is Positive
0497 3673              ;
0498 3673 A5 D6                 lda   LeftEdge                 ; subtract adjust from left
0499 3675 38                    sec                            ; edge
0500 3676 E5 E2                 sbc   Adjust
0501 3678 85 D6                 sta   LeftEdge
0502 367A A5 D8                 lda   LeftEdge+2
0503 367C E5 E4                 sbc   Adjust+2
0504 367E 85 D8                 sta   LeftEdge+2
0505 3680
0506 3680 A5 D4                 lda   Slope+2                  ; check to see if slope is less
0507 3682 F0 04                 beq   Less1                    ; than 1
0508 3684
0509 3684 C6 DC                 dec   RightEdge+2              ; if not less sub 1 from right edge
0510 3686 80 34                 bra   SlopeOk
0511 3688
0512 3688 A5 D6        Less1    lda   LeftEdge                 ; is less so add slope to left edge
0513 368A 18                    clc   
0514 368B 65 D2                 adc   Slope
0515 368D 85 D6                 sta   LeftEdge
0516 368F A5 D8                 lda   LeftEdge+2
0517 3691 65 D4                 adc   Slope+2
0518 3693 85 D8                 sta   LeftEdge+2
0519 3695 80 25                 bra   SlopeOK
0520 3697
0521 3697
0522 3697              ;-----------------------------------------------
0523 3697              ;
0524 3697              ; Slope Is Negative
0525 3697              ;
0526 3697 A5 DA        IsNegative lda   RightEdge              ; subtract adjust from right
0527 3699 38                    sec                            ; edge
0528 369A E5 E2                 sbc   Adjust
0529 369C 85 DA                 sta   RightEdge
0530 369E A5 DC                 lda   RightEdge+2
0531 36A0 E5 E4                 sbc   Adjust+2
0532 36A2 85 DC                 sta   RightEdge+2
0533 36A4
0534 36A4 A5 D4                 lda   Slope+2                  ; check to see if slope is more
0535 36A6 C9 FF FF              cmp   #$FFFF                   ; than minus 1
0536 36A9 F0 04                 beq   More1
0537 36AB
0538 36AB E6 D8                 inc   LeftEdge+2               ; not more so add 1 to LeftEdge
0539 36AD 80 0D                 bra   SlopeOK
0540 36AF
0541 36AF A5 DA        More1    lda   RightEdge                ; is more so add slope to edge
0542 36B1 18                    clc   
0543 36B2 65 D2                 adc   Slope
0544 36B4 85 DA                 sta   RightEdge
0545 36B6 A5 DC                 lda   RightEdge+2
0546 36B8 65 D4                 adc   Slope+2
0547 36BA 85 DC                 sta   RightEdge+2
0548 36BC
0549 36BC              SlopeOK                                 ; 
0550 36BC
0551 36BC              ;------------------------------------------------
0552 36BC              ;
0553 36BC              ;   Get ready to draw
0554 36BC              ;
0555 36BC              ;------------------- START OF FASTLINE CHANGE --------------------------
0556 36BC
0557 36BC              ;
0558 36BC              ;----- assume they're rectangular unless proven otherwise -----
0559 36BC              ;
0560 36BC A7 54                 lda   [RgnPtrA]
0561 36BE 07 64                 ora   [RgnPtrB]
0562 36C0 C9 0A 00              cmp   #10
0563 36C3 D0 20                 bne   GoSlow
0564 36C5 64 A4                 stz   NonRectRegions           ;regions are rectangular
0565 36C7 22 E8 1E E0           jsl   SetSlabAdr               ; sets up the slab adr on zp
0566 36CB B0 18                 bcs   GoSlow
0567 36CD E0 00 00              cpx   #0                       ; test if <X> says mode copy...
0568 36D0 F0 0C                 beq   DoModeCopy
0569 36D2 E0 08 00              cpx   #8                       ; test if mode XOR
0570 36D5 D0 18                 bne   SkipInit2Regions
0571 36D7 A9 00 40              lda   #$4000                   ; set bits to flag mode xor fastslab
0572 36DA 85 2A                 sta   temp
0573 36DC 80 11                 bra   SkipInit2Regions
0574 36DE
0575 36DE A9 00 80     DoModeCopy lda   #$8000                 ; set bits to flag mode copy fastslab
0576 36E1 85 2A                 sta   temp
0577 36E3 80 0A                 bra   SkipInit2Regions
0578 36E5
0579 36E5
0580 36E5              ;
0581 36E5              ; ---- End of change ----
0582 36E5              ;
0583 36E5              GoSlow    
0584 36E5 22 C0 1E E0           jsl   Init2Regions             ;set up the initial clip buffer
0585 36E9 22 E8 1E E0           jsl   SetSlabAdr
0586 36ED 80 01                 bra   SkipKludge
0587 36EF              SkipInit2Regions  
0588 36EF 18                    clc   
0589 36F0 08           SkipKludge php                          ;save state of carry
0590 36F1
0591 36F1              ;
0592 36F1              ;------------------- END OF FASTLINE CHANGE ----------------------------
0593 36F1
0594 36F1              ;------------------------------------------------
0595 36F1              ;
0596 36F1              ; If line was cliped, we have to adjust the
0597 36F1              ; edges.
0598 36F1
0599 36F1 A5 A6                 lda   Y1                       ; if Y1 still equals
0600 36F3 C5 AE                 cmp   Rect2                    ; Rect2.Top then no clipping
0601 36F5 F0 2C                 beq   TopOK                    ; has occured.
0602 36F7
0603 36F7 38                    sec                            ; Calculate discard amount
0604 36F8 E5 AE                 sbc   Rect2
0605 36FA
0606 36FA 48                    pha                            ; Make room for result
0607 36FB 48                    pha   
0608 36FC
0609 36FC 48                    pha                            ; push this amount on stack
0610 36FD F4 00 00              pea   0                        ; followed by a zero to represent
0611 3700 D4 D4                 pei   Slope+2                  ; discard as a fixed point number
0612 3702 D4 D2                 pei   Slope                    ; Then push Slope
0613 3704 A2 0B 0F 22           _FixMul 
0614 370B FA                    plx                            ; get result in x and y
0615 370C 7A                    ply   
0616 370D
0617 370D
0618 370D 8A                    txa   
0619 370E 18                    clc   
0620 370F 65 D6                 adc   LeftEdge
0621 3711 85 D6                 sta   LeftEdge
0622 3713 98                    tya   
0623 3714 65 D8                 adc   LeftEdge+2
0624 3716 85 D8                 sta   LeftEdge+2
0625 3718
0626 3718 8A                    txa   
0627 3719 18                    clc   
0628 371A 65 DA                 adc   RightEdge
0629 371C 85 DA                 sta   RightEdge
0630 371E 98                    tya   
0631 371F 65 DC                 adc   RightEdge+2
0632 3721 85 DC                 sta   RightEdge+2
0633 3723
0634 3723
0635 3723              ;------------------------------------------------
0636 3723              ;
0637 3723              ;   Find starting point of scan line
0638 3723              ;
0639 3723 20 47 34     TopOK    jsr   SetFirstDestRef
0640 3726
0641 3726
0642 3726              ;---------------------------------------------------
0643 3726              ;
0644 3726              ;   Move left and right edge of clipped line rect
0645 3726              ;   from X1, X2 to Rect2+2 and Rect2+4
0646 3726              ;
0647 3726 A5 A8                 lda   X1
0648 3728 85 B0                 sta   Rect2+2
0649 372A A5 AA                 lda   Y2
0650 372C 85 B2                 sta   Rect2+4
0651 372E A5 AC                 lda   X2
0652 3730 85 B4                 sta   Rect2+6
0653 3732
0654 3732 8A                    txa                            ; this was result of calc above
0655 3733
0656 3733              ;------------------- START OF FASTLINE CHANGE --------------------------
0657 3733 28                    plp   
0658 3734 90 5E                 bcc   FastLine
0659 3736              ;------------------- END OF FASTLINE CHANGE ----------------------------
0660 3736
0661 3736
0662 3736              ;---------------------------------------------------
0663 3736              ;
0664 3736              ; The Drawing Loop !
0665 3736              ;
0666 3736              LineLoop                                ; 
0667 3736
0668 3736              ;--------------------------------------------------
0669 3736              ;
0670 3736              ; Put left and right edges were slab routine will
0671 3736              ; look for them and clip to Rect2 at the same time
0672 3736              ;
0673 3736 A5 DC                 lda   RightEdge+2
0674 3738 C5 B4                 cmp   Rect2+6
0675 373A 30 02                 bmi   RightOk
0676 373C A5 B4                 lda   Rect2+6
0677 373E 85 AC        RightOK  sta   X2
0678 3740
0679 3740 A5 D8                 lda   LeftEdge+2
0680 3742 C5 B0                 cmp   Rect2+2
0681 3744 10 02                 bpl   LeftOk
0682 3746 A5 B0                 lda   Rect2+2
0683 3748 85 A8        LeftOk   sta   X1
0684 374A
0685 374A C5 AC                 cmp   X2                       ; if left >= right then
0686 374C 10 0F                 bpl   BackHere                 ; skip the drawing step
0687 374E
0688 374E 22 70 1E E0           jsl   XSetup                   ; set up stuff for slab routines
0689 3752
0690 3752
0691 3752              ;-----------------------------------------------------------
0692 3752              ;
0693 3752              ;   Now have to pull out right slice of pattern for
0694 3752              ;   y coordinate
0695 3752              ;
0696 3752 20 C5 34              jsr   NextPatSlice
0697 3755 22 CC 1E E0           jsl   Seek2Regions
0698 3759
0699 3759 22 00 1E E0           jsl   ToSlab
0700 375D
0701 375D A5 40        BackHere lda   CurrentY
0702 375F 1A                    inc   a
0703 3760 C5 AA                 cmp   Y2
0704 3762 10 22                 bpl   TheEnd
0705 3764
0706 3764 85 40                 sta   CurrentY
0707 3766
0708 3766 A5 D6                 lda   LeftEdge                 ; adjust the left edge
0709 3768 18                    clc   
0710 3769 65 D2                 adc   Slope
0711 376B 85 D6                 sta   LeftEdge
0712 376D A5 D8                 lda   LeftEdge+2
0713 376F 65 D4                 adc   Slope+2
0714 3771 85 D8                 sta   LeftEdge+2
0715 3773
0716 3773 A5 DA                 lda   RightEdge                ; adjust the right edge
0717 3775 18                    clc   
0718 3776 65 D2                 adc   Slope
0719 3778 85 DA                 sta   RightEdge
0720 377A A5 DC                 lda   RightEdge+2
0721 377C 65 D4                 adc   Slope+2
0722 377E 85 DC                 sta   RightEdge+2
0723 3780
0724 3780 20 F4 34              jsr   SetNextDestRef
0725 3783 4C 36 37              jmp   LineLoop
0726 3786
0727 3786
0728 3786
0729 3786              TheEnd                                  ; 
0730 3786 22 9C 1E E0           jsl   UnShieldCursor
0731 378A              NeverMind                               ; 
0732 378A 22 A8 1E E0           jsl   FreePortRegions
0733 378E AB                    plb                            ; restore the bank register
0734 378F
0735 378F A9 00 00              lda   #0
0736 3792 18                    clc   
0737 3793 6B                    rtl   
0738 3794
0739 3794              ;------------------------START OF FASTLINE STUFF--------------------------------
0740 3794              ;
0741 3794              ; The Fast line drawing code
0742 3794              ;
0743 3794              ;---------------------------------------------------------------
0744 3794              patIndex equ   CurrentY
0745 3794              lineCount equ   Y2
0746 3794              ;---------------------------------------------------------------
0747 3794
0748 3794              FastLine  
0749 3794              ;	pei	CurrentY	;save the stuff we're going to use
0750 3794              ;	pei	Y2	;for temporary space
0751 3794
0752 3794 A2 00 02              ldx   #512                     ; test for solid patterns
0753 3797 B5 EC                 lda   <DirtyDPFlags,x
0754 3799 29 00 88              and   #SolidPatOK+DirtyFlagsOK
0755 379C C9 00 88              cmp   #SolidPatOK+DirtyFlagsOK
0756 379F D0 03                 bne   @DitherPat
0757 37A1 4C 46 38              jmp   FastLineSolidPat
0758 37A4              @DitherPat  
0759 37A4 A5 AA                 lda   Y2
0760 37A6 38                    sec   
0761 37A7 E5 40                 sbc   CurrentY
0762 37A9 85 AA                 sta   lineCount
0763 37AB
0764 37AB A5 40                 lda   CurrentY                 ;find the current index into the FillPat and DrawMask
0765 37AD 29 07 00              and   #7                       ;..tables
0766 37B0 0A                    asl   a
0767 37B1 0A                    asl   a
0768 37B2 69 00 01              adc   #256
0769 37B5 85 40                 sta   patIndex
0770 37B7 AA                    tax   
0771 37B8
0772 37B8 B5 0E        Floop    lda   TheFillPat,x
0773 37BA 85 CA                 sta   Pat
0774 37BC B5 10                 lda   TheFillPat+2,x
0775 37BE 85 CC                 sta   Pat+2
0776 37C0
0777 37C0 A5 B6                 lda   FillMode
0778 37C2 10 0E                 bpl   @doTheSlab
0779 37C4
0780 37C4              ;
0781 37C4              ; Invert the pattern
0782 37C4              ;
0783 37C4 A5 CA        @doNOT   lda   Pat
0784 37C6 49 FF FF              eor   #$FFFF
0785 37C9 85 CA                 sta   Pat
0786 37CB A5 CC                 lda   Pat+2
0787 37CD 49 FF FF              eor   #$FFFF
0788 37D0 85 CC                 sta   Pat+2
0789 37D2
0790 37D2              @doTheSlab  
0791 37D2              ;--------------------------------------------------
0792 37D2              ;
0793 37D2              ; Put left and right edges were slab routine will
0794 37D2              ; look for them and clip to Rect2 at the same time
0795 37D2              ;
0796 37D2 A5 DC                 lda   RightEdge+2
0797 37D4 C5 B4                 cmp   Rect2+6
0798 37D6 30 02                 bmi   @RightOk
0799 37D8 A5 B4                 lda   Rect2+6
0800 37DA 85 AC        @RightOK sta   X2
0801 37DC
0802 37DC A5 D8                 lda   LeftEdge+2
0803 37DE C5 B0                 cmp   Rect2+2
0804 37E0 10 02                 bpl   @LeftOk
0805 37E2 A5 B0                 lda   Rect2+2
0806 37E4 85 A8        @LeftOk  sta   X1
0807 37E6
0808 37E6 C5 AC                 cmp   X2                       ; if left >= right then
0809 37E8 10 12                 bpl   @BackHere                ; skip the drawing step
0810 37EA
0811 37EA 22 70 1E E0           jsl   XSetup                   ; set up stuff for slab routines
0812 37EE A6 C4                 ldx   <startWord               ; try to short circut the slabs...
0813 37F0 E4 C6                 cpx   <finishWord
0814 37F2 D0 04                 bne   @oldSlab
0815 37F4 24 2A                 bit   temp                     ; recover our flags
0816 37F6 70 40                 bvs   @NewSlabXor              ; if overflow clear nomode xor
0817 37F8              @oldSlab  
0818 37F8 22 00 1E E0           jsl   ToSlab
0819 37FC
0820 37FC              @SlabDone  
0821 37FC A5 40        @BackHere lda   patIndex
0822 37FE 18                    clc   
0823 37FF 69 04 00              adc   #4                       ;inc a four times
0824 3802 29 1F 01              and   #$011F
0825 3805 85 40                 sta   patIndex
0826 3807 AA                    tax                            ;patIndex in x-reg expected in Floop
0827 3808
0828 3808 C6 AA                 dec   lineCount
0829 380A F0 37                 beq   allDone
0830 380C
0831 380C A5 D6                 lda   LeftEdge                 ; adjust the left edge
0832 380E 18                    clc   
0833 380F 65 D2                 adc   Slope
0834 3811 85 D6                 sta   LeftEdge
0835 3813 A5 D8                 lda   LeftEdge+2
0836 3815 65 D4                 adc   Slope+2
0837 3817 85 D8                 sta   LeftEdge+2
0838 3819
0839 3819 A5 DA                 lda   RightEdge                ; adjust the right edge
0840 381B 18                    clc   
0841 381C 65 D2                 adc   Slope
0842 381E 85 DA                 sta   RightEdge
0843 3820 A5 DC                 lda   RightEdge+2
0844 3822 65 D4                 adc   Slope+2
0845 3824 85 DC                 sta   RightEdge+2
0846 3826
0847 3826 A5 BC                 lda   DestRef
0848 3828 18                    clc   
0849 3829 65 12                 adc   Width
0850 382B 85 BC                 sta   DestRef
0851 382D 90 89                 bcc   Floop
0852 382F
0853 382F E6 BE                 inc   DestRef+2
0854 3831 D4 BD                 pei   destref+1
0855 3833 AB                    plb   
0856 3834 AB                    plb   
0857 3835 82 80 FF              brl   Floop
0858 3838              @NewSlabXor  
0859 3838              ; NOTE: <X> has startword and <A> has right mask!
0860 3838 9B                    txy                            ; setup <Y> to point to byte
0861 3839 25 CA                 and   <pat
0862 383B 25 A0                 and   <leftMask
0863 383D 57 BC                 eor   [DestRef],y              	;invert & store it
0864 383F 97 BC                 sta   [DestRef],y
0865 3841 80 B9                 bra   @SlabDone
0866 3843
0867 3843
0868 3843              ;---------------------------------------------------------------
0869 3843              allDone   
0870 3843              ;	pla
0871 3843              ;	sta	Y2
0872 3843              ;	pla
0873 3843              ;	sta	CurrentY
0874 3843 82 40 FF              brl   TheEnd
0875 3846
0876 3846              ;------------------------------------------------------------------
0877 3846              ; even faster fastline stuff here...
0878 3846
0879 3846              FastLineSolidPat  
0880 3846              ;	pei	CurrentY	;save the stuff we're going to use
0881 3846              ;	pei	Y2	;for temporary space
0882 3846
0883 3846 A5 AA                 lda   Y2
0884 3848 38                    sec   
0885 3849 E5 40                 sbc   CurrentY
0886 384B 85 AA                 sta   lineCount
0887 384D
0888 384D A2 00 01              ldx   #256
0889 3850 B5 0E                 lda   TheFillPat,x
0890 3852 85 CA                 sta   Pat
0891 3854 85 CC                 sta   Pat+2
0892 3856
0893 3856 A5 B6                 lda   FillMode
0894 3858 10 09                 bpl   @doTheSlab
0895 385A
0896 385A              ;
0897 385A              ; Invert the pattern
0898 385A              ;
0899 385A A5 CA        @doNOT   lda   Pat
0900 385C 49 FF FF              eor   #$FFFF
0901 385F 85 CA                 sta   Pat
0902 3861 85 CC                 sta   Pat+2
0903 3863
0904 3863              @doTheSlab  
0905 3863              ;--------------------------------------------------
0906 3863              ;
0907 3863              ; Put left and right edges were slab routine will
0908 3863              ; look for them and clip to Rect2 at the same time
0909 3863              ;
0910 3863 A5 DC                 lda   RightEdge+2
0911 3865 C5 B4                 cmp   Rect2+6
0912 3867 30 02                 bmi   @RightOk
0913 3869 A5 B4                 lda   Rect2+6
0914 386B 85 AC        @RightOK sta   X2
0915 386D
0916 386D A5 D8                 lda   LeftEdge+2
0917 386F C5 B0                 cmp   Rect2+2
0918 3871 10 02                 bpl   @LeftOk
0919 3873 A5 B0                 lda   Rect2+2
0920 3875 85 A8        @LeftOk  sta   X1
0921 3877
0922 3877 C5 AC                 cmp   X2                       ; if left >= right then
0923 3879 10 12                 bpl   @BackHere                ; skip the drawing step
0924 387B
0925 387B 22 70 1E E0           jsl   XSetup                   ; set up stuff for slab routines
0926 387F A6 C4                 ldx   <startWord               ; try to short circut the slabs...
0927 3881 E4 C6                 cpx   <finishWord
0928 3883 D0 04                 bne   @oldSlab
0929 3885 24 2A                 bit   temp                     ; recover our flags
0930 3887 70 33                 bvs   @NewSlabXor              ; if overflow clear nomode xor
0931 3889              @oldSlab  
0932 3889 22 00 1E E0           jsl   ToSlab
0933 388D
0934 388D              @SlabDone  
0935 388D              @BackHere  
0936 388D C6 AA                 dec   lineCount
0937 388F F0 B2                 beq   allDone
0938 3891
0939 3891 A5 D6                 lda   LeftEdge                 ; adjust the left edge
0940 3893 18                    clc   
0941 3894 65 D2                 adc   Slope
0942 3896 85 D6                 sta   LeftEdge
0943 3898 A5 D8                 lda   LeftEdge+2
0944 389A 65 D4                 adc   Slope+2
0945 389C 85 D8                 sta   LeftEdge+2
0946 389E
0947 389E A5 DA                 lda   RightEdge                ; adjust the right edge
0948 38A0 18                    clc   
0949 38A1 65 D2                 adc   Slope
0950 38A3 85 DA                 sta   RightEdge
0951 38A5 A5 DC                 lda   RightEdge+2
0952 38A7 65 D4                 adc   Slope+2
0953 38A9 85 DC                 sta   RightEdge+2
0954 38AB
0955 38AB A5 BC                 lda   DestRef
0956 38AD 18                    clc   
0957 38AE 65 12                 adc   Width
0958 38B0 85 BC                 sta   DestRef
0959 38B2 90 AF                 bcc   @doTheSlab
0960 38B4
0961 38B4 E6 BE                 inc   DestRef+2
0962 38B6 D4 BD                 pei   destref+1
0963 38B8 AB                    plb   
0964 38B9 AB                    plb   
0965 38BA 80 A7                 bra   @doTheSlab
0966 38BC
0967 38BC              ;------------------------END OF FASTLINE STUFF--------------------------------
0968 38BC              @NewSlabXor  
0969 38BC              ; NOTE: <X> has startword and <A> has right mask!
0970 38BC 9B                    txy                            ; setup <Y> to point to byte
0971 38BD 25 CA                 and   <pat
0972 38BF 25 A0                 and   <leftMask
0973 38C1 57 BC                 eor   [DestRef],y              	;invert & store it
0974 38C3 97 BC                 sta   [DestRef],y
0975 38C5 80 C6                 bra   @SlabDone
0976 38C7
0977 38C7                       ENDP 
0978 38C7
0979 38C7
0980 38C7              ****************************************************************
0981 38C7              *
0982 38C7              * GrabPenLoc
0983 38C7              *
0984 38C7              * Takes PnLoc from the port and puts in Y1,X1 and
0985 38C7              * at Rect2
0986 38C7              *
0987 38C7              ****************************************************************
0988 38C7                       EXPORT GrabPenLoc 
0989 38C7              GrabPenLoc PROC 
0990 38C7              *              using CoreDATA
0991 38C7
0992 38C7
0993 38C7 A0 40 00              ldy   #O_PnLoc
0994 38CA B7 24                 lda   [PortRef],y
0995 38CC 85 A6                 sta   Y1
0996 38CE 85 AE                 sta   Rect2
0997 38D0 C8                    iny   
0998 38D1 C8                    iny   
0999 38D2 B7 24                 lda   [PortRef],y
1000 38D4 85 A8                 sta   X1
1001 38D6 85 B0                 sta   Rect2+2
1002 38D8
1003 38D8 60                    rts   
1004 38D9
1005 38D9                       ENDP 
1006 38D9
1007 38D9              ****************************************************************
1008 38D9              *
1009 38D9              * StabPenLoc
1010 38D9              *
1011 38D9              * Xrefs Y2,X2 to PnLoc in the port.
1012 38D9              *
1013 38D9              ****************************************************************
1014 38D9                       EXPORT StabPenLoc 
1015 38D9              StabPenLoc PROC 
1016 38D9              *              using CoreDATA
1017 38D9
1018 38D9
1019 38D9 A0 40 00              ldy   #O_PnLoc
1020 38DC A5 AA                 lda   Y2
1021 38DE 97 24                 sta   [PortRef],y
1022 38E0 C8                    iny   
1023 38E1 C8                    iny   
1024 38E2 A5 AC                 lda   X2
1025 38E4 97 24                 sta   [PortRef],y
1026 38E6
1027 38E6
1028 38E6 60                    rts   
1029 38E7
1030 38E7                       ENDP 
1031 38E7
1032 38E7              *******************************************************************************
1033 38E7              *
1034 38E7              FastRatio proc Export 
1035 38E7              *
1036 38E7              * Description:	A faster version of intmaths fixratio
1037 38E7              *
1038 38E7              *
1039 38E7              * Inputs:	None
1040 38E7              *
1041 38E7              * Outputs:	None
1042 38E7              *
1043 38E7              * External Refs:
1044 38E7              *
1045 38E7              * Entry Points:
1046 38E7              *
1047 38E7              *******************************************************************************
1048 38E7              M1       equ   1
1049 38E7              origdPage equ   M1+4
1050 38E7              rts1     equ   origDPage+2
1051 38E7              denom    equ   rts1+2
1052 38E7              Numerator equ   Denom+2
1053 38E7              Result   equ   Numerator+2
1054 38E7              Quotient equ   M1
1055 38E7              Remainder equ   Quotient+2              ; remainder from first div high word of second
1056 38E7
1057 38E7 0B                    phd                            ; save the direct page
1058 38E8 DA                    phx   
1059 38E9 DA                    phx                            ; room for M1 and M2
1060 38EA 3B                    tsc   
1061 38EB 5B                    tcd   
1062 38EC A5 09                 lda   Denom
1063 38EE D0 08                 bne   GoOnX
1064 38F0 A9 FF 7F              lda   #$7FFF
1065 38F3 85 0F                 sta   Result+2
1066 38F5 82 83 00              brl   TheEnd
1067 38F8
1068 38F8 45 0B        GoOnX    eor   Numerator
1069 38FA 48                    pha                            ; save sign info...
1070 38FB
1071 38FB A5 0B                 lda   Numerator                ; strip the signes for later
1072 38FD 10 06                 bpl   @numPos
1073 38FF 49 FF FF              eor   #$FFFF
1074 3902 1A                    inc   a
1075 3903 85 0B                 sta   Numerator
1076 3905              @NumPos   
1077 3905 A5 09                 lda   Denom
1078 3907 10 06                 bpl   @DenPos
1079 3909 49 FF FF              eor   #$FFFF
1080 390C 1A                    inc   a
1081 390D 85 09                 sta   Denom
1082 390F
1083 390F C5 0B        @DenPos  cmp   Numerator                ; see if denom is bigger
1084 3911 B0 20                 bge   noDiv
1085 3913              ; first things first, lets start our division off
1086 3913              ; 
1087 3913              DoDivide  
1088 3913 64 01                 stz   M1
1089 3915 64 03                 stz   M1+2
1090 3917
1091 3917 A5 0B                 lda   Numerator
1092 3919 85 01                 sta   Quotient
1093 391B A0 10 00              ldy   #16
1094 391E 38                    sec                            ; set carry to start
1095 391F 26 01        @DivLoop rol   Quotient                 ; 
1096 3921 26 03                 rol   Quotient+2
1097 3923 38                    sec   
1098 3924 A5 03                 lda   Quotient+2
1099 3926 E5 09                 sbc   Denom
1100 3928 90 02                 bcc   @DecCt
1101 392A 85 03                 sta   Quotient+2
1102 392C 88           @DecCt   dey   
1103 392D D0 F0                 bne   @DivLoop
1104 392F 26 01                 rol   Quotient
1105 3931 80 11                 bra   Cont
1106 3933              NoDiv     
1107 3933 F0 08                 beq   theSame
1108 3935 64 01                 stz   Quotient
1109 3937 A5 0B                 lda   Numerator
1110 3939 85 03                 sta   Remainder
1111 393B 80 07                 bra   Cont
1112 393D 64 03        theSame  stz   Remainder
1113 393F A9 01 00              lda   #1
1114 3942 85 01                 sta   Quotient
1115 3944              ;
1116 3944              ; The divide is done now
1117 3944              Cont      
1118 3944              ;
1119 3944              ; Now we do the long divide!
1120 3944 A5 01                 lda   Quotient
1121 3946 85 0F                 sta   Result+2
1122 3948 64 0D                 stz   Result
1123 394A A5 03                 lda   Remainder                ; test the remainder for 0
1124 394C F0 1B                 beq   LongDivDone
1125 394E
1126 394E 48                    pha   
1127 394F 48                    pha   
1128 3950 48                    pha   
1129 3951 48                    pha   
1130 3952
1131 3952 48                    pha   
1132 3953 F4 00 00              pea   0
1133 3956
1134 3956 F4 00 00              pea   0
1135 3959 A5 09                 lda   Denom
1136 395B 48                    pha   
1137 395C A2 0B 0D 22           _LongDivide 
1138 3963 68                    pla   
1139 3964 85 0D                 sta   Result
1140 3966 68                    pla   
1141 3967 68                    pla   
1142 3968 68                    pla   
1143 3969
1144 3969              LongDivDone  
1145 3969 68                    pla                            ; get sign off stack
1146 396A 10 0F                 bpl   theEnd
1147 396C A9 00 00              lda   #0
1148 396F 38                    sec   
1149 3970 E5 0D                 sbc   Result
1150 3972 85 0D                 sta   Result
1151 3974 A9 00 00              lda   #0
1152 3977 E5 0F                 sbc   Result+2
1153 3979 85 0F                 sta   Result+2
1154 397B              theEnd    
1155 397B FA                    plx                            ; get our shit off the stack!
1156 397C FA                    plx   
1157 397D 2B                    pld                            ; get the direct page
1158 397E A3 01                 lda   1,s                      ; get the return address
1159 3980 83 05                 sta   5,s                      ; and move it down...
1160 3982 68                    pla   
1161 3983 68                    pla   
1162 3984 60                    rts   
1163 3985
1164 3985                       EndP 
1165 3985
1166 3985
1167 3985                       END   
